# billing_analyzer.py
# A simple, beginner-friendly Python script that summarizes billing data from a text file.

from collections import defaultdict

def analyze_billing_file(filepath):
    total_invoices = 0
    total_amount = 0.0
    client_totals = defaultdict(float)
    client_counts = defaultdict(int)

    with open(filepath, "r") as file:
        for line in file:
            parts = line.strip().split()
            if len(parts) != 4:
                continue

            _, _, client, amount = parts
            amount = amount.replace("$", "")

            try:
                amount = float(amount)
            except ValueError:
                continue

            total_invoices += 1
            total_amount += amount
            client_totals[client] += amount
            client_counts[client] += 1

    print("Billing Summary")
    print("----------------")
    print(f"Total invoices: {total_invoices}")
    print(f"Total billed amount: ${total_amount:.2f}")

    if total_invoices:
        print(f"Average invoice amount: ${total_amount / total_invoices:.2f}")

    print("\nBreakdown by client:")
    for client in sorted(client_totals):
        print(
            f"  {client}: "
            f"{client_counts[client]} invoices, "
            f"${client_totals[client]:.2f} total"
        )

def main():
    billing_file = "example.txt"
    analyze_billing_file(billing_file)

if __name__ == "__main__":
    main()
